% WURZEL DOCUMENT STYLE -- Released September 2004 for LaTeX2e
% SHORT VERSION -- ONLY FOR SINGLE ARTICLES
%
% USAGE: \documentclass[OPTIONS]{wzl2005}
%        \title[HEADTITLE]{TITLE}
%        \author[NAME BELOW TITLE]{NAME, PLACE}
%        \begin{document}
%          \maketitle
%          THE DOCUMENT TEXT
%          \makeauthor
%         \end{docuemnt}
%
% OPTIONS:
%   [full]: Include some less common packages used in the full wurzelclass

\def\wzlversion{2005}
\def\filedate{2004/11/23}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{wzl\wzlversion}[\filedate]

%%% FIND OUT WHETHER LATEX OR PDFLATEX
\newif\ifpdflatex
\newif\ifpdfoutput
\pdflatexfalse
\pdfoutputfalse
\ifx\pdfoutput\undefined\else
  \ifx\pdfoutput\relax\else
    \ifcase\pdfoutput
    \else
      \pdflatextrue
      \pdfoutputtrue
    \fi
  \fi
\fi

%%% DECLARE OPTIONS
\newif\iffull\fullfalse
\DeclareOption{full}{\fulltrue}
\ProcessOptions

%%% LOAD CLASS AND PACKAGES
\LoadClass[twoside]{article}            % LOAD CLASS
\RequirePackage[latin1]{inputenc}       % LATIN1 INPUT ENCODING
\RequirePackage[ngerman]{babel}[2001/03/01] % NEW GERMAN WITH \frenchspacing
\RequirePackage{amsmath,amssymb,amsthm} % AMS-PACKAGES
\RequirePackage{eurosym}                % THE EURO-CURRENCY-SYMBOL
\RequirePackage{xspace}                 % FOR THE \Wurzel-Logo
\RequirePackage{t1enc}                  % T1 FONT ENCODING
\ifpdfoutput
  \RequirePackage{ae,aecompl}           % ALMOST EUROPEAN VIRTUAL FONTS FOR PDF
  \RequirePackage[pdftex]{graphicx}     % FOR INCLUDING GRAPHICS
  \DeclareGraphicsExtensions{.png,.tif,.jpg,.mps}
  \DeclareGraphicsRule{*}{mps}{*}{}     % METAPOST SUPPORT FOR PDFLATEX
  \pdfcompresslevel=9
\else
  \RequirePackage[dvips]{graphicx}
  \DeclareGraphicsExtensions{.eps}
\fi
\iffull
  \RequirePackage{ifthen,calc}
  \RequirePackage{caption}              % CAPTIONS, SEE WZLPAGExxxx.STY
  \RequirePackage{booktabs}             % NICE TABLES
  \heavyrulewidth0.17ex
  \lightrulewidth0.10ex
  \belowrulesep0.5ex
  \ifpdfoutput
    \RequirePackage[a4paper]{hyperref}  % HYPERREFS AND \url-COMMAND
  \else
    \RequirePackage[a4paper,dvips]{hyperref}
  \fi
\else
  \RequirePackage{url}                  % \url-COMMAND
\fi



%%% WURZEL-LOGO
\DeclareRobustCommand\Wurzel[1][\relax]{\ensuremath{%
  \ifx#1\relax
    \sqrt{\text{WURZEL}}
  \else
    \sqrt[\!\!\text{#1}]{\text{WURZEL}}
  \fi\!\:}\xspace}

%%% PAGE LAYOUT
\paperheight297mm
\paperwidth210mm
\oddsidemargin22mm
\evensidemargin22mm
\textwidth115mm
\textheight492pt
\parindent0pt
\parskip0.5ex plus 0.3ex minus 0.3ex

%%% REDEFINE PAGESTYLE
\def\ps@headings{%
  \topmargin12pt
  \headheight15pt
  \topskip0pt
  \headsep15pt
  \footskip35pt
  \let\@mkboth\@gobbletwo
  \let\partmark\@gobble
  \let\sectionmark\partmark
  \let\subsectionmark\partmark
  \let\subsubsectionmark\partmark
  % Style and Contents of Head and Footlines
  \def\innerheadstyle{\small\sffamily\sbcseries\mathversion{bold}}
  \def\outerheadstyle{\small\sffamily\bfseries}
  \def\innerfootstyle{\small\sffamily\bfseries}
  \def\outerfootstyle{\small\sffamily\bfseries}
  \def\innerhead{\leftmark}
  \def\outerhead{\thepage}
  \def\innerfoot{\Wurzel}
  \def\outerfoot{}
  %
  \def\makehead##1##2{%
      \parbox\textwidth{\makebox[\textwidth]{{##1}\hspace*\fill{##2}}%
      \rule[-2pt]{0pt}{11pt}\vspace{1.5pt}\hrule}}
  \def\makefoot##1##2{%
      \parbox\textwidth{\hrule\vspace{1.5pt}\makebox[\textwidth]{{##1}\hspace*\fill{##2}}}}
  \def\@evenhead{\makehead{\outerheadstyle\outerhead}{\innerheadstyle\innerhead}}
  \def\@oddhead {\makehead{\innerheadstyle\innerhead}{\outerheadstyle\outerhead}}
  \def\@evenfoot{\makefoot{\outerfootstyle\outerfoot}{\innerfootstyle\innerfoot}}
  \def\@oddfoot {\makefoot{\innerfootstyle\innerfoot}{\outerfootstyle\outerfoot}}
}

%%% LAYOUT SPECIFICATIONS
\renewcommand\arraystretch{1.1}
\iffull
  \captionsetup{font={small,sf},labelfont=bf,justification=centerlast}
  \abovecaptionskip0.5\abovecaptionskip
  %%% CAPTION WITHOUT LABELTEXT
  \newcommand\shortcaption{{\captionsetup{labelsep=period}\caption{}}}
\fi
\pagestyle{headings}
\def\refname{Literatur}

%%% NON FLOATING FIGURES
\newenvironment{fixedfigure}[1][\linewidth]
  {\begin{minipage}{#1}\def\@captype{figure}}
  {\end{minipage}}

%%% TITLE AND AUTHOR COMMANDS
\renewcommand\author[1]{\def\@author{#1}}
\renewcommand\title[2][\@title]{\def\@title{#2}\def\@headtitle{#1}}
\renewcommand\maketitle{%
  \@maketitle%
  \markboth\@headtitle\@headtitle%
}
\newcommand\maketitleauthor{%
  \@maketitle[author]%
  \markboth\@headtitle\@headtitle%
}
\renewcommand\@maketitle[1][]{%
  \def\contentsignore##1{##1}%
  \def\onlycontents##1{}%
  {\Large\begin{center}
     \vspace*{-0.5ex}
     {\sffamily\bfseries\@title}
     \def\@titleauthor{#1}
     \par\smallskip
     \ifx\@titleauthor\@empty\else
       {\normalsize\rmfamily\mdseries\scshape\textup{von} \@author}
     \fi
   \end{center}
  }\nopagebreak%
}
\newcommand\makeauthor{\@makeauthor}
\newcommand\@makeauthor{\par\nopagebreak%
  \begin{flushright}{\slshape\@author}\end{flushright}%
  \vspace{-2ex}%
}

%%% SECTION COMMANDS
\newlength\secsep\setlength\secsep{3ex plus 1ex minus 0.3ex}
\def\section{\@startsection{section}      {1}{0pt}{0.8\secsep}{0.5\secsep}{\large\bfseries}}
\def\subsection{\@startsection{subsection}      {2}{0pt}{0.7\secsep}{0.3\secsep}{\bfseries}}
\def\subsubsection{\@startsection{subsubsection}{3}{0pt}{0.6\secsep}{0.2\secsep}{\bfseries}}
\setcounter{secnumdepth}{2}
\newcommand\minisection[1]{\par\medskip{\sectionfont#1}\nopagebreak\par\nopagebreak}

%%% PROLOGUE EPILOGUE
\newenvironment{prologue}
  {\begin{small}\sffamily\slshape}
  {\par\end{small}}
\newenvironment{epilogue}
  {\par\medskip\begin{small}\sffamily\slshape}
  {\par\end{small}}

%%% FONTDEFINITIONS
%%% Computer Modern Variable-Width Typewriter
\providecommand\vttfamily{\fontfamily{cmvtt}\selectfont}
\DeclareTextFontCommand{\textvtt}{\vttfamily}
%%% bold - medium width
\providecommand\bmseries{\fontseries{b}\selectfont}
\DeclareTextFontCommand{\textbm}{\bmseries}
%%% semi bold - condensed
\providecommand\sbcseries{\fontseries{sbc}\selectfont}
\DeclareTextFontCommand{\textsbc}{\sbcseries}
%%% FONT SUBSTITUTIONS FOR PDFLATEX
\ifpdfoutput
  \let\vttfamily\ttfamily
\fi

%%% DECLARE SANS MATHVERSIONS
\newif\ifsans\sansfalse
\newif\ifbold\boldfalse
\providecommand\setmathversion{%
  \ifsans
    \ifbold\mathversion{sansbold}\else\mathversion{sans}\fi
  \else
    \ifbold\mathversion{bold}\else\mathversion{normal}\fi
  \fi
}
\DeclareMathAlphabet{\mathsfsl}{OT1}{\sfdefault}{m}{sl}
\DeclareOldFontCommand{\sfsl}{\normalfont\sffamily\slshape}{\mathsfsl}
\DeclareMathAlphabet{\mathsfbf}{OT1}{\sfdefault}{bx}{sl}
\DeclareOldFontCommand{\sfbf}{\normalfont\sffamily\bfseries}{\mathsfbf}
\DeclareMathVersion{sans}
\DeclareMathVersion{sansbold}
\SetMathAlphabet{\mathrm}  {sans}{OT1}{\sfdefault}{m}{n}
\SetMathAlphabet{\mathsfsl}{sans}{OT1}{\sfdefault}{m}{sl}
\SetMathAlphabet{\mathsfbf}{sans}{OT1}{\sfdefault}{bx}{n}
\SetSymbolFont{operators}{sans}{OT1}{\sfdefault}{m}{n}
\SetSymbolFont{letters}  {sans}{OML}{cmbr}{m}{it}
\SetSymbolFont{symbols}  {sans}{OMS}{cmsy}{m}{n}
\SetMathAlphabet{\mathrm}  {sansbold}{OT1}{\sfdefault}{bx}{n}
\SetMathAlphabet{\mathsfsl}{sansbold}{OT1}{\sfdefault}{bx}{sl}
\SetMathAlphabet{\mathsfbf}{sansbold}{OT1}{\sfdefault}{bx}{n}
\SetSymbolFont{operators}{sansbold}{OT1}{\sfdefault}{bx}{n}
\SetSymbolFont{letters}  {sansbold}{OML}{cmbrm} {b}{it}
\SetSymbolFont{symbols}  {sansbold}{OMS}{cmsy}{b}{n}
%%% MAKE MATH BOLD/SANS IN BOLD/SANS TEXT ENVIRONMENT
\let\tmp@mdseries\mdseries \def\mdseries{\tmp@mdseries\mathversion{normal}}
\let\tmp@bfseries\bfseries \def\bfseries{\tmp@bfseries\boldtrue\setmathversion}
\let\tmp@bmseries\bmseries \def\bmseries{\tmp@bmseries\boldtrue\setmathversion}
\let\tmp@sffamily\sffamily \def\sffamily{\tmp@sffamily\sanstrue\setmathversion}

%%% CYRILLIC FONTS
\DeclareFontFamily{U}{wncyr}{\hyphenchar\font45}
\DeclareFontShape{U}{wncyr}{m}{n}{<->wncyr10}{}
\DeclareFontShape{U}{wncyr}{m}{it}{<->wncyi10}{}
\DeclareFontShape{U}{wncyr}{m}{sc}{<->wncysc10}{}
\DeclareFontShape{U}{wncyr}{b}{n}{<->wncyb10}{}
\DeclareFontShape{U}{wncyr}{bx}{n}{<->ssub*wncyr/b/n}{}
\providecommand\cyrfamily{\fontencoding{U}\fontfamily{wncyr}\selectfont}
\DeclareTextFontCommand{\textcyr}{\cyrfamily}

\endinput
